/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	TechScene
**
** DESCRIPTION:	Tech scene displays current and available tech levels
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef THE_TECH_SCENE_H
#define THE_TECH_SCENE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwScene.h"
#include "ldwButton.h"
#include "ldwTextControl.h"
#include "../Game/Tech.h"
#include "../Utils/theGraphicsManager.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CTechScene : public ldwScene
{
private:

	//class enumerations
	enum EButton
	{
		eButton_Done = 0,

		eButton_ScienceBuy,
		eButton_MedicineBuy,
		eButton_AlchemyBuy,
		eButton_RestorationBuy,
		eButton_FarmingBuy,
		eButton_NatureBuy,
		eButton_MagicBuy,

		eButton_ScienceInfo,
		eButton_MedicineInfo,
		eButton_AlchemyInfo,
		eButton_RestorationInfo,
		eButton_FarmingInfo,
		eButton_NatureInfo,
		eButton_MagicInfo,

		eButton_NumberOf
	};

	//class structures
	struct STech
	{
		EImage				m_eImage;
		int					m_iXPos;
		int					m_iYPos;
		bool				m_bIsHorizontal;
	};

	//class data
	static CTechScene *		m_pInstance;
	static STech			sm_sTech[eTech_NumberOf];

	ldwButton *				m_pButton[eButton_NumberOf];
	ldwTextControl *		m_pSceneLabel;
	ldwTextControl *		m_pPlayerCommField;
	ldwTextControl *		m_pTechInfo[eTech_NumberOf];
	ldwTextControl *		level1Label;
	ldwTextControl *		level2Label;
	ldwTextControl *		level3Label;
	ldwTextControl *		factionLabel;

	float					m_fTechAlpha[eTech_NumberOf][Tech_c_iMaxLevel];
	float					m_fBeamAlpha[2];

	ETech					m_eCurrentPath;

	//class methods
	//setup
	private:	CTechScene();
	private:	~CTechScene();
	public:		static CTechScene *Get();
	public:		static CTechScene &Ref();
	public:		static void Destroy();

	//prevent copy
	public:		CTechScene(const CTechScene &);
	public:		CTechScene & operator = (const CTechScene &);

	//process
	protected:	void Activate(bool bIsActive);
	protected:	void UpdateScene();
	protected:	void DrawScene();
	private:	void ShowTechInfo(const ETech eTech);
	public:		bool HandleKey(int iMessageID, int iKeyCode, int iCharacter);
	public:		bool HandleMessage(int iMessageID, long iData);
	public:		bool HandleMouse(int iMessageID, ldwPoint sMousePos);

	//access
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/